package default;
use vars qw/$standardheader/;
use strict;
$standardheader = <<'EOF';
<!-- This is part of CGI:IRC 0.5 (http://cgiirc.org/)
  == Copyright (C) 2000-2008 David Leadbeater <http://dgl.cx>
  == Released under the GNU GPLv2
  -->
EOF

sub new {
   return bless {};
}

sub exists {
   return 1 if defined &{__PACKAGE__ . '::' . $_[1]};
}

sub makeline {
   my($self, $type, $target, $html) = @_;
   return "$html<br />\n";
}

sub lines {
   my($self, @lines);
   unless(print @lines) {
      $::needtodie++;
   }
}

sub header {
   print "\n";
}

sub keepalive {
   unless(print "<!-- nothing comment -->\r\n") {
      $::needtodie++;
   }
}

sub error {
   my($self, $error) = @_;
   $self->line({}, '', $error);
}

sub form { 'DUMMY' }

sub add { 'DUMMY' }

sub del { 'DUMMY' }

sub clear { 'DUMMY' }

sub end { 'DUMMY' }

sub options { 'DUMMY' }

sub setoption { 'DUMMY' }

# not supported by default interface
sub ctcpping { 0 }
sub ping { 0 }

sub login {
   my($self, $this, $interface, $copy, $config, $order, $items, $adv) = @_;
   my $notsupported = 0;
   # Seems to work on Safari 2 (WebKit >=4xx):
   # http://developer.apple.com/internet/safari/uamatrix.html
   if ($ENV{HTTP_USER_AGENT} =~ /konqueror.2|Mozilla\/4.\d+ \[|OmniWeb|Safari\/(\d{2}|[1-3]\d{2})(\D|$)|Mozilla\/4.\d+ .*Mac_PowerPC/i) {
      $notsupported++;
   }

print <<EOF;
$standardheader
<html>
<head>
<link rel="SHORTCUT ICON" href="$config->{image_path}/favicon.ico">
<style type="text/css">
	html {
		box-sizing:border-box;
		font-family:Helvetica,Trebuchet,Arial,sans-serif;
	}
</style>
<script language="JavaScript"><!--
EOF
if($interface eq 'default') {
print <<EOF;
function setjs() {
 if(navigator.product == 'Gecko') {
   document.loginform["interface"].value = 'mozilla';
 }else if(window.opera && document.childNodes) {
   document.loginform["interface"].value = 'opera7';
 }else if(navigator.appName == 'Microsoft Internet Explorer' &&
    navigator.userAgent.indexOf("Mac_PowerPC") > 0) {
    document.loginform["interface"].value = 'konqueror';
 }else if(navigator.appName == 'Microsoft Internet Explorer' &&
 document.getElementById && document.getElementById('ietest').innerHTML) {
   document.loginform["interface"].value = 'ie';
 }else if(navigator.appName == 'Konqueror') {
    document.loginform["interface"].value = 'konqueror';
 }else if(window.opera) {
   document.loginform["interface"].value = 'opera';
 }
}
EOF
}else{ # dummy functions
print <<EOF;
function setjs() {
   return true;
}
EOF
}
print <<EOF;
function setcharset() {
	if(document.charset && document.loginform["Character set"]) {
                var opt = document.createElement("option")
                opt.value = document.charset
		document.loginform['Character set'].appendChild(opt)

        }
}
function selectOther(sel) {
  if(sel.value == '_Other...') {
    var opt=document.createElement('option')
    if(opt.value=prompt(sel.name.replace(/_/, ' '), '')) {
      opt.appendChild(document.createTextNode(opt.value))
      sel.insertBefore(opt, sel.lastChild)
      sel.selectedIndex=sel.length-2
    } else {
      sel.selectedIndex=0
    }
  }
}
//-->
</script>
<!-- <title>CGI:IRC Login</title> -->
<title>BSDForAll | WebChat - Login</title>
<style type="text/css">
	html {
		background-image:url("../assets/themeCNY/clipart-fireworks-firework-chinese-15b.webp"), url("../img-742824-most-popular-openbsd-wallpaper-1920x1080_Black.webp");
		background-repeat:no-repeat, no-repeat;
		background-position:center bottom, center center;
		-webkit-background-size:cover,cover; -moz-background-size:cover,cover; -o-background-size:cover,cover; background-size:cover,cover;
		margin:0; padding:0; width:100%; /*height:100%;*/ min-height:100vh;
		background-color:rgba(2,16,39,0.75) /*#021027*/ /*navy blue*/;

		box-sizing:border-box;
		font-family:Helvetica,Trebuchet,Arial,sans-serif;
	}
	.center {
		/*position:relative;*/
		position:absolute;
		height:390px;
		width:auto;
		padding:11px;
		border:3px solid green;
		border-radius:5px;

		margin:0;
		top:50%;
		left:50%;
		transform:translate(-50%,-50%);
	}
</style>
</head>
<body bgcolor="#ffffff" text="#000000" onload="setcharset(); if(document.loginform.Nickname) document.loginform.Nickname.focus();">
<center>
<div class="center">
EOF
if($notsupported) {
	print "<font size=\"+1\" color=\"red\">This web-based IRC interface probably won't work well or at all with your browser.</font>\n<br /><b>You could try a <a href=\"http://irchelp.org\">non web-based IRC client</a> or a browser such as <a href=\"http://www.getfirefox.com/\">Mozilla Firefox</a>.</b><br /><br />\n";
}
print <<EOF;
<form method="post" action="$this" name="loginform" onsubmit="setjs()">
EOF
print "<input type=\"hidden\" name=\"interface\" value=\"" . 
   ($interface eq 'default' ? 'nonjs' : $interface) . "\">\n";

# print <<EOF;
# <table border="0" cellpadding="5" cellspacing="0">
# <tr><td colspan="2" align="center" bgcolor="#c0c0dd"><b>CGI:IRC Login</b></td></tr>
# EOF
print <<EOF;
<a href="#">
	<img class="img-hor" style="width:55px; height:auto; text-align:center; vertical-align:middle; horizontal-align:center;" alt="BSDPufferfish" src="../faviconR_150x150.png" />
	<span style="color:rgba(255,51,0,1); font-weight:bold; text-align:center; vertical-align:middle; horizontal-align:center; text-shadow:0 0 3px #FF0000, 0 0 5px #0000FF;">BSD<span style="color:rgba(255,204,0,1); font-weight:bold; text-align:center; vertical-align:middle; horizontal-align:center; text-shadow:0 0 3px #FF0000, 0 0 5px #0000FF;">ForAll</span></span>
</a>
<table border="0" cellpadding="5" cellspacing="0">
<tr><td colspan="2" align="center" bgcolor="#c0c0dd">
<b><span style="color:rgba(255,51,0,1); text-shadow:0 0 3px #FF0000, 0 0 5px #0000FF;">BSD<span style="color:rgba(255,204,0,1); text-shadow:0 0 3px #FF0000, 0 0 5px #0000FF;">ForAll</span></span>&nbsp;|&nbsp;WebChat&nbsp;Login</b>
<hr />
<div style="background-color:#c0c0dd;">
<a href="/" rel="nofollow" target="_self" style="text-decoration:none;">
	<img style="width:55px; height:auto; text-align:center; vertical-align:middle; horizontal-align:center;" alt="BSDPufferfish" src="../assets/icon_home.png" />
</a>
</div>
<hr />
</td></tr>
EOF
for(@$order) {
   my $item = $$items{$_};
   next unless defined $item;
   print "<tr><td align=\"right\" bgcolor=\"#f1f1f1\">$_</td><td align=\"left\"
bgcolor=\"#f1f1f1\">";
   if(ref $item eq 'ARRAY') {
      s/ /_/g;
      print "<select name=\"$_\" style=\"width: 100%\"";

      my $disabled = 0;
      if($_ eq 'Format' || $item->[0] eq '-DISABLED-') {
        $disabled = 1;
        shift @$item if $item->[0] eq '-DISABLED-';
        print ">";
      } else {
        print " onchange=\"selectOther(this)\">";
      }
      print "<option value='$_'>$_</option>" for @$item;
      print "<script><!--\ndocument.write('<option value=\"_Other...\">Other...</option>');\n//-->\n</script>" unless $disabled;
      print "</select>\n<noscript><small>Other: </small><input type='text' name='${_}_text'></noscript>\n";
   }elsif($item eq '-PASSWORD-') {
      print "<input type=\"password\" name=\"$_\" value=\"\">";
   }else{
      my $tmp = '';
      if($item =~ s/^-DISABLED- //) {
         $tmp = " disabled=\"1\"";
      }
      print "<input type=\"text\" name=\"$_\" value=\"$item\"$tmp>";
   }
   print "</td></tr>\n";
}
print <<EOF;
<tr><td align="left" bgcolor="#c0c0dd" /*bgcolor="#d9d9d9"*/>
EOF
if($adv) {
   print <<EOF;
<small><!-- <a href="$this?adv=1">Advanced..</a> --></small>
EOF
}
print <<EOF;
</td><td align="right" bgcolor="#c0c0dd" /*bgcolor="#d9d9d9"*/>
<input type="submit" value="Login" style="background-color: #d9d9d9">
</td></tr></table></form>

<small id="ietest">$copy</small>
</div>
</center>
</body></html>
EOF
}

sub reconnect {
  my($self, $url, $text) = @_;
  return "<a href=\"$url\" target=\"_top\">$text</a>";
}

1;
